/*************************************************************************************************
 * @file Common.h
 *
 * @brief This header aggregation of common Hilscher headers.
 * It includes headers out of following scopes:
 * -# CifX
 * -# rcX
 * -# TLR
 * 
 * @author Elmar
 *
 */

/* prevent multiple inclusion */
#ifndef __COMMON_H
#define __COMMON_H

#ifdef WIN32
  #include "stdint.h"
  #include "Windows.h"
#endif

// include all common Hilscher headers (rcX, TLR, cifX, ...)

#include "TLR_Types.h"
#include "TLR_Results.h"
#include "TLR_Packet.h"

#include "cifXErrors.h"
#include "cifXUser.h"

#include "rcx_error.h"
#include "rcX_Public.h"
#include "rcX_User.h"
#include "rX_Types.h"

#endif  /* __COMMON_H */
